<?php

namespace App\Models\Truck;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class Driver extends Model
{
    use SoftDeletes;
    protected $table = 'truck_drivers';

    protected $fillable = ['first_name', 'last_name', 'jmbg', 'image',  'phone', 'email'];
    
    public function invoices()
    {
        return $this->belongsToMany(Invoice::class, 'invoice_driver', 'driver_id', 'invoice_id');
    }
}
