<?php

namespace App\Models\Truck;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class InvoiceProcurement extends Model
{
    use SoftDeletes;
    protected $table = 'truck_invoices_procurement';

    protected $fillable = ['id_invoice', 'text', 'company', 'date_start', 'date_end', 'date_done', 'price', 'currency', 'status'];
    
public function company()
{
    return $this->belongsTo(CompanyProcurement::class, 'company_id');
}
}
