<?php

use Illuminate\Database\Seeder;

class AclNewPermissionsSeeder extends Seeder
{
    private $tableName = 'acl_permissions';
    private $newAclPermissions = [
        'tv-scheme',
        'firestore-users',
        'comic'
    ];
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        foreach($this->newAclPermissions as $permission){
            $foundPermission = \DB::table($this->tableName)->where('slug', \Str::slug($permission))->get();
            if($foundPermission->isEmpty()){
                \DB::table($this->tableName)->insert([
                    'name' => $permission,
                    'slug' => \Str::slug($permission),
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }

        }
    }
}
