/*
* Embed Media Dialog based on http://www.fluidbyte.net/embed-youtube-vimeo-etc-into-ckeditor
*
* Plugin name:      mediaembed
* Menu button name: MediaEmbed
*
* Youtube Editor Icon
* http://paulrobertlloyd.com/
*
* @author Fabian Vogelsteller [frozeman.de]
* @version 0.5
*/
( function() {
	CKEDITOR.plugins.add( 'relatedArticles', {
		icons: 'relatedArticles', // %REMOVE_LINE_CORE%
		hidpi: true, // %REMOVE_LINE_CORE%
		init: function(editor) {
			var relatedArticles = this;
            var relatedArticlesModal = getRelatedArticlesModal();

            editor.addCommand('relatedArticles', {
            	exec: function(editor) {
					
					$('#relatedArticlesModal').on('click.myEvent', 'div.list-related-article-actions a', function(e){
						e.preventDefault();
						var selection = editor.getSelection();
						let selectedText = "";
						selectedText = selection.getSelectedText();
						let heading = $(this).data('article-heading');
						let href = $(this).data('article-url');
						let linkHtml;
						
						if(selectedText == ''){
							linkHtml = '<a target="_blank" href="' + href + '">' + heading + '</a>';
						}else{
							linkHtml = '<a target="_blank" href="' + href + '">' + selectedText + '</a>';
							
						}

						editor.insertHtml(linkHtml);
						editor.focus();
						
					});

                	relatedArticlesModal.openModal(null, function() {
                    	editor.focus();
					});
            	}
            });

            editor.ui.addButton( 'RelatedArticles', {
                label: 'Povezane Vesti',
                command: 'relatedArticles',
                icon: 'relatedArticles',
                toolbar: 'relatedArticles'
            });

            if (editor.contextMenu) {
            	editor.addMenuGroup('relatedArticles');

        		editor.contextMenu.addListener(function(element, selection) {

        			if (selection.getType() == CKEDITOR.SELECTION_TEXT) {
        				editor.addMenuItems({
        					RelatedArticleLink: {
        	                   label : 'Linkuj Povezanu Vest',
        	                   icon: 'relatedArticles',
        	                   command : 'relatedArticles',
        	                   group : 'relatedArticles',
        	                   order : 98
        					}
        	            });

            			return {
            				RelatedArticleLink: CKEDITOR.TRISTATE_OFF
                        };
        			} else if (selection.getType() == CKEDITOR.SELECTION_NONE) {
        				editor.addMenuItems({
        					RelatedArticle: {
        	                   label : 'Ubaci Link Za Povezanu Vest',
        	                   icon: 'relatedArticles',
        	                   command : 'relatedArticles',
        	                   group : 'relatedArticles',
        	                   order : 98
        					}
        	            });

            			return {
            				RelatedArticle: CKEDITOR.TRISTATE_OFF
                        };
        			}
                });
        	}
        }
    });
})();
