
@push('head_links')
    <link href="{{asset('/custom/ckeditor/contents.css')}}" rel="stylesheet" type="text/css"/>
@endpush
<form id="entity-form" class="form-horizontal" method="post" action="" 
      enctype="multipart/form-data" autocomplete="off">
      @csrf
    <div class="form-group row">
        <label class="col-sm-3 control-label">@lang('Naziv fajla')<sup>*</sup></label>
        <div class="col-sm-9">
            <input 
                type="text" 
                class="form-control @errorClass('name', 'is-invalid')" 
                name="name" 
                placeholder="@lang('Naziv')" 
                value="{{old('name', $entity->name)}}"
                data-index="1"
            >
            @formError(['field' => 'name'])
        </div>
    </div>
    <div class="form-group row">
        <label class="col-sm-3 control-label">@lang('Fajl')</label>
        <div class="col-sm-9">
            <input 
                type="file" 
                class="form-control filestyle @errorClass('pdf_file', 'is-invalid')" 
                name="pdf_file" 
                placeholder="@lang('Fajl')"
                data-index="3"
            >
            @formError(['field' => 'pdf_file'])
        </div>
    </div>
    
    @if($entity->file_path)
    <div class="form-group row">
        <label class="col-sm-3 control-label">@lang('PDF fajl')</label>
        <div class="col-sm-9">
        <embed src="{{$entity->getFileUrl()}}" width="450" height="450">
        </div>
    </div>
    @endif
    <div class="form-group row">
        <label class="col-sm-3 control-label">@lang('Slika')</label>
        <div class="col-sm-9">
            <input 
                type="file" 
                class="form-control filestyle @errorClass('image', 'is-invalid')" 
                name="image" 
                placeholder="@lang('Slika')"
                data-index="3"
            >
            @formError(['field' => 'image'])
        </div>
    </div>
    @if($entity->image)
    <div class="form-group row">
        <label class="col-sm-3 control-label">@lang('Prikaz Slike')</label>
        <div class="col-sm-9">
        <img src="{{$entity->getImageUrl()}}" width="450" height="450">
        </div>
    </div>
    @endif
    <hr>
    <div class="form-group row">
        <div class="col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light" id="button" data-index="4">
                <i class="fa fa-save"></i>
                @lang('Sačuvaj')
            </button>
        </div>
    </div>
</form>

@push('footer_scripts')
<script type="text/javascript" src="{{url('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')}}"></script>
<script>

    $('#entity-form').validate({
        "rules": {
            "name": {
                required: true,
                maxlength: 50
            },
        }
    });

    $(document).on("keypress", 'form', function (e) {
        let code = e.keyCode || e.which;

        let $this = $(e.target);
        let index = parseFloat($this.attr('data-index'));
        
        if (code == 13) {

            e.preventDefault();

            if($this.attr('type') == 'submit'){
                $this.click();
            }

            let input = $('[data-index="' + (index + 1).toString() + '"]');

            input.focus();

            if(input.attr('type') == 'file'){
                input.click();

            }
            
        }
    });

</script>
@endpush