<div class="row">
    <div class="col-lg-6">
        <fieldset>
            <legend class="h4 text-muted pb-3">
                @lang('Podaci o firmi')
            </legend>
            <table class="table table-striped">
                <tbody>
                    <tr>
                        <th>@lang('Naziv firme')</th>
                        <td class="w-50 form-group">
                            <input 
                                type="text"
                                class="form-control col-sm-3 @errorClass('newscms.title', 'is-invalid')"
                                name="newscms[title]"
                                value="{{old('newscms.title', setting('newscms.title'))}}"
                            >
                            @formError(['field' => 'newscms.title'])
                        </td>
                    </tr>
                    <tr>
                        <th>@lang('PIB')</th>
                        <td class="w-50 form-group">
                            <div class="input-group">
                                <input 
                                    type="text"
                                    class="form-control col-sm-3 @errorClass('newscms.pib', 'is-invalid')"
                                    name="newscms[pib]"
                                    value="{{old('newscms.pib', setting('newscms.pib'))}}"
                                >
                                <div class="input-group-append">
                                    <button 
                                        title="@lang('Pretraga baze Narodne banke Srbije')"
                                        class="btn btn-warning"
                                        type="button"
                                        data-action="nbs-pretraga-po-pibu"
                                    >
                                        <i class="fa fa-search"></i>
                                    </button>
                                </div>
                                @formError(['field' => 'newscms.pib'])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th>@lang('Matični broj')</th>
                        <td class="w-50 form-group">
                            <div class="input-group">
                            <input 
                                type="text"
                                class="form-control col-sm-3 @errorClass('newscms.identification_number', 'is-invalid')"
                                name="newscms[identification_number]"
                                value="{{old('newscms.identification_number', setting('newscms.identification_number'))}}"
                            >
                            <div class="input-group-append">
                                    <button 
                                        title="@lang('Pretraga baze Narodne banke Srbije')"
                                        class="btn btn-warning"
                                        type="button"
                                        data-action="nbs-pretraga-po-maticnom-broju"
                                    >
                                        <i class="fa fa-search"></i>
                                    </button>
                                </div>
                            @formError(['field' => 'newscms.identification_number'])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                            <span class="text-muted">@lang('Podaci o adresi')</span>
                        </th>
                    </tr>
                    <tr>
                        <th>@lang('Postanski broj')</th>
                        <td class="w-50 form-group">
                            <input
                                id="post_number_autocomplete"
                                type="text"
                                class="form-control col-sm-3 @errorClass('newscms.post_number', 'is-invalid')"
                                name="newscms[post_number]"
                                value="{{old('newscms.post_number', setting('newscms.post_number'))}}"
                            >
                             @formError(['field' => 'newscms.post_number'])
                        </td>
                    </tr>
                    <tr>
                        <th>@lang('Mesto')</th>
                        <td class="w-50 form-group">
                            <input 
                                id="naselje_autocomplete"
                                type="text"
                                class="form-control col-sm-3 @errorClass('newscms.city', 'is-invalid')"
                                name="newscms[city]"
                                value="{{old('newscms.city', setting('newscms.city'))}}"
                            >
                            @formError(['field' => 'newscms.city'])
                        </td>
                    </tr>
                    <tr>
                        <th>@lang('Adresa')</th>
                        <td class="w-50 form-group">
                            <input 
                                type="text"
                                class="form-control col-sm-3 @errorClass('newscms.address', 'is-invalid')"
                                name="newscms[address]"
                                value="{{old('newscms.address', setting('newscms.address'))}}"
                            >
                            @formError(['field' => 'newscms.address'])
                        </td>
                    </tr>
                    <tr>
                        <th colspan="2">
                            <span class="text-muted">@lang('Podaci o kontaktu')</span>
                        </th>
                    </tr>
                    <tr>
                        <th>@lang('Email')</th>
                        <td class="w-50 form-group">
                            <input 
                                type="text"
                                class="form-control col-sm-3 @errorClass('newscms.email', 'is-invalid')"
                                name="newscms[email]"
                                value="{{old('newscms.email', setting('newscms.email'))}}"
                            >
                            @formError(['field' => 'newscms.email'])
                        </td>
                    </tr>
                    <tr>
                        <th>@lang('Telefon')</th>
                        <td class="w-50 form-group">
                            <input 
                                type="text"
                                class="form-control col-sm-3 @errorClass('newscms.phone', 'is-invalid')"
                                name="newscms[phone]"
                                value="{{old('newscms.phone', setting('newscms.phone'))}}"
                            >
                            @formError(['field' => 'newscms.phone'])
                        </td>
                    </tr>
                    <tr>
                        <th>@lang('Mobilni')</th>
                        <td class="w-50 form-group">
                            <input 
                                type="text"
                                class="form-control col-sm-3 @errorClass('newscms.mobile_phone', 'is-invalid')"
                                name="newscms[mobile_phone]"
                                value="{{old('newscms.mobile_phone', setting('newscms.mobile_phone'))}}"
                            >
                            @formError(['field' => 'newscms.mobile_phone'])
                        </td>
                    </tr>
                </tbody>
            </table>
        </fieldset>
    </div>
    <div class="col-lg-6">
        <fieldset>
            <legend class="h5 text-muted pb-3">
                &nbsp;
            </legend>
            <div class="form-group">
                @include('_layout.partials.form.image_upload', [
                    'label' => __('Slika za logo'),
                    'name' => 'newscms[logo]',
                    'defaultImageUrl' => config('newscms.default_logo_img_src'),
                    'imageObj' => setting('newscms.logo') && $newsCmsLogo->hasImage('image_logo') 
                        ? $newsCmsLogo->getImage('image_logo') : null,
                    'width' => 384,
                    'height' => 128,
                    'deleteImageAjaxUrl' => setting('newscms.logo') && $newsCmsLogo->hasImage('image_logo')
                        ? route('admin.settings.delete_image', [
                            'entity' => $newsCmsLogo->id,
                            'imageClass' => 'image_logo'
                        ])
                        : '',
                ])
                <span class="form-control @errorClass('newscms.logo', 'is-invalid') d-none"></span>
                @formError(['field' => 'newscms.logo'])
                <hr>
            </div>
            
            <div class="form-group">
                @include('_layout.partials.form.image_upload', [
                    'label' => __('Slika za ikonicu'),
                    'name' => 'newscms[icon]',
                    'defaultImageUrl' => config('newscms.default_icon_img_src'),
                    'imageObj' => setting('newscms.icon') && $newsCmsIcon->hasImage('image_icon') 
                        ? $newsCmsIcon->getImage('image_icon') : null,
                    'width' => 64,
                    'height' => 64,
                    'deleteImageAjaxUrl' => setting('newscms.icon') && $newsCmsIcon->hasImage('image_icon')
                        ? route('admin.settings.delete_image', [
                            'entity' => $newsCmsIcon->id,
                            'imageClass' => 'image_icon'
                        ])
                        : '',
                ])
                <span class="form-control @errorClass('newscms.icon', 'is-invalid') d-none"></span>
                @formError(['field' => 'newscms.icon'])
                <hr>
            </div>
        </fieldset>
    </div>
</div>
<hr>
@push('footer_scripts')
<script src="{{asset('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')}}"></script>
<script src="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.js')}}"></script>
@endpush