@push('head_links')
<link href="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.css')}}" rel="stylesheet" />
@endpush

<form id="entity-form" class="form-horizontal" method="post" action="" 
      enctype="multipart/form-data" autocomplete="off">
    <div class="row">
        <div class="col-lg-7 align-self-center">
            @csrf
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Ime firme')</label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control @errorClass('name', 'is-invalid')" 
                        name="name" 
                        placeholder="@lang('Ime firme')" 
                        value="{{old('name', $entity->name)}}"
                    >
                    @formError(['field' => 'name'])
                    
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Adresa')</label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control @errorClass('address', 'is-invalid')" 
                        name="address" 
                        placeholder="@lang('Adresa')" 
                        value="{{old('address', $entity->address)}}"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-home"></i>
                        </span>
                    </span>
                    @formError(['field' => 'address'])
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('JIB')</label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control @errorClass('jib', 'is-invalid')" 
                        name="jib" 
                        placeholder="@lang('JIB')" 
                        value="{{old('jib', $entity->jib)}}"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-id-card-o"></i>
                        </span>
                    </span>
                    @formError(['field' => 'jib'])
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('PDV')</label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control @errorClass('pdv', 'is-invalid')" 
                        name="pdv" 
                        placeholder="@lang('PDV')" 
                        value="{{old('pdv', $entity->pdv)}}"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-id-card-o"></i>
                        </span>
                    </span>
                    @formError(['field' => 'pdv'])
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Email')</label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control @errorClass('email', 'is-invalid')" 
                        name="email" 
                        placeholder="@lang('Email')" 
                        value="{{old('email', $entity->email)}}"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-at"></i>
                        </span>
                    </span>
                    @formError(['field' => 'email'])
                    
                </div>
            </div>
            
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Telefon')</label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control @errorClass('phone', 'is-invalid')" 
                        name="phone" 
                        placeholder="@lang('Telefon')" 
                        value="{{old('phone', $entity->phone)}}"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-phone"></i>
                        </span>
                    </span>
                    @formError(['field' => 'phone'])
                    
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Valuta')</label>
                <div class="col-sm-9 input-group">
                    <select 
                        class="form-control @errorClass('currency', 'is-invalid')" 
                        name="currency"
                    >
                        <option value="KM" {{ old('currency', $entity->currency) == 1 ? 'selected' : '' }}>KM</option>
                        <option value="EUR" {{ old('currency', $entity->currency) == 2 ? 'selected' : '' }}>EUR</option>
                    </select>
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-money"></i>
                        </span>
                    </span>
                    @formError(['field' => 'currency'])
                </div>
            </div>
            
            
        </div>
        <div class="col-4 offset-1">
            {{-- slika --}}
        </div>
    </div>
    <hr>
    <div class="form-group row">
        <div class="col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light">
                <i class="fa fa-save"></i>
                @lang('Sačuvaj')
            </button>
        </div>
    </div>
</form>

@push('footer_scripts')
<script src="{{asset('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')}}"></script>
<script src="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.js')}}"></script>
<script>
$(function() {
    
    $(document).ready(function() {
    $('#entity-form').validate({
        rules: {
            name: {
                required: true
            },
            address: {
                required: true
            },
            currency: {
                required: true
            },
            jib: {
                required: true,
                maxlength: 20
            },
            phone: {
                required: true,
                maxlength: 20
            },
            email: {
                required: true,
                email: true
            },
        },
        messages: {
            
        },
    });
});

});
</script>
@endpush