@extends('_layout.layout')

@section('head_title', __('Vozači') . ' - ' . __('Vozači'))

@push('head_links')

@endpush

@section('content')

@include('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Vozači"),
    'breadcrumbs' => [
        route('truck.drivers') => __('Vozači')
    ]
])

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title">@lang('Lista Vozača')</h3>
                </div>
                <div class="card-heading-actions">
                    <a href="{{route('truck.drivers_create')}}" class="btn btn-primary">
                        <i class="fa fa-plus"></i>
                        @lang('Dodaj')
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped" id="entity-list-table">
                        <thead>
                            <tr>
                                <th class="">@lang('Slika')</th>
                                <th class="">@lang('Ime')</th>
                                <th class="">@lang('Prezime')</th>
                                <th class="">@lang('Email')</th>
                                <th class="">@lang('JMBG')</th>
                                <th class="">@lang('Telefon')</th>
                                <th class="disabled-sorting text-right">@lang('Opcije')</th>
                            </tr>
                        </thead>
                        <tbody>
    
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('footer_scripts')
<script>
$(function() {
    
    var blade = {
        datatablesAjaxUrl:"@route('truck.drivers_datatable')"
    };
    
    // DATATABLES
    $('#entity-list-table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            url: blade.datatablesAjaxUrl,
            type: "post",
        },
        "columns": [
            {"data": "image", orderable: false, searchable: false, "className": ""},
            {"data": "first_name", "className": ""},
            {"data": "last_name", "className": ""},
            {"data": "email", "className": ""},
            {"data": "jmbg", "className": ""},
            {"data": "phone", "className": ""},
            {"data": "actions", orderable: false, searchable: false, "className": "text-right"}
        ],
        "order": [[0, "asc"]]
    });
    
    
    // DELETE MODAL
    let options = {
        "title": "Obriši",
        "liveSelector": '[data-action="delete"]'
    };
    
    $('#entity-list-table').questionPop(options).on('success.qp', function() {
        $('#entity-list-table').DataTable().draw('page');
    });

});
</script>
@endpush