<form id="entity-form" class="form-horizontal" method="get" action="{{route('finance_add_new_payment')}}"
    enctype="multipart/form-data" autocomplete="off">
    @csrf
    <div class="row">
        <div class="col-lg-10">
            <div class="form-group">
                <label class="control-label">@lang('Firma')</label>
                <select id="companySelect" name="company" class="form-control @errorClass('company', 'is-invalid') enterable">
                    <option value="0" disabled selected>@lang('Izaberi')</option>
                    @foreach($companies as $company)
                    <option value="{{$company->id}}" data-currency="{{$company->currency}}" @if(old('company', $entity->company) == $company->id) selected @endif>{{$company->name}}</option>
                    @endforeach
                </select>
                @formError(['field' => 'company'])
            </div>
        </div>  
        <div class="col-lg-2">
            <div id="currencyDisplay" class="form-group">
                <label class="control-label invisible">@lang('Valuta')</label> <!-- Nevidljiva labela za poravnanje -->
                <input 
                    id="currency"
                    type="text" 
                    class="form-control @errorClass('price', 'is-invalid') enterable" 
                    name="currency" 
                    placeholder="@lang('Valuta')" 
                    value=""
                    readonly
                >
            </div>
        </div>  
    </div>
    
    <hr>
    <div class="row second" id="additional-section" style="display: none;">
        <div class="col-lg-12">
            <div class="row">
                <div class="col-lg-4">
                    <div class="form-group">
                        <label class="control-label">@lang('Datum uplate na racun')</label>
                            <input
                                type="text"
                                class="form-control @errorClass('date_start', 'is-invalid') enterable"
                                name="date_start"
                                id="date_start"
                                placeholder="@lang('Datum')"
                                value=""
                            >
                        @formError(['field' => 'date_start'])
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="form-group">
                        <label class="control-label">@lang('Referentni broj')</label>
                            <input 
                                type="text" 
                                class="form-control @errorClass('reference', 'is-invalid') enterable" 
                                name="reference" 
                                placeholder="@lang('Referentni broj')" 
                                value=""
                            >
                        @formError(['field' => 'price'])
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="form-group">
                        <label class="control-label">@lang('Ukupan iznos za uplatu')</label>
                            <input 
                                type="text" 
                                class="form-control @errorClass('price', 'is-invalid') enterable" 
                                name="price" 
                                placeholder="@lang('0.00')" 
                                value=""
                            >
                        @formError(['field' => 'price'])
                    </div>
                </div>
            </div>
        </div>
    </div>
    <hr>
        <div id="invoices" class="col-lg-12">
            
        </div>
    
    <hr>
    <div class="form-group row" id="submit-section" style="display: none;">
        <div class="col-sm-12 button-right">
            <button type="submit" class="btn btn-success waves-effect waves-light" id="button" data-index="4">
                <i class="fa fa-save"></i>
                @lang('Sačuvaj')
            </button>
        </div>
    </div>
</form>

@push('head_links')
<link href="/theme/plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css" rel="stylesheet">
<link href="/packages/fileinput/fileinput.css" rel="stylesheet">

<style>
    #currency {
        text-align: center;
    }
    .form-group input[readonly] {
        background-color: white; /* Opcionalno: stilizacija readonly inputa */
    }

    .button-right{
        display: flex;
        justify-content: flex-end;
    }

    #invoices {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
    }

    .invoice {
        display: flex;
        flex-direction: column;
        padding: 10px;
        border: 1px solid #ddd;
        background-color: #f9f9f9;
        min-width: 200px;
        margin-bottom: 10px;
    }

    .invoice p {
        margin: 0;
        padding: 5px 0;
    }

    .total-value {
        flex-basis: 100%;
        padding: 10px;
        border-top: 2px solid #333;
        margin-top: 10px;
    }
</style>
@endpush

@push('footer_scripts')
<script type="text/javascript" src="{{url('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')}}"></script>
<script src="/theme/plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js"></script>
<script src="/packages/fileinput/fileinput.min.js"></script>
<script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.15.0/additional-methods.js"></script>

<script>
    $(function () {

        $('select').select2({
            minimumResultsForSearch: -1
        });

        $('#date_start').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true
        });

        // FRONTEND VALIDACIJA
        $('#entity-form').validate({
            rules: {
                date_start:{
                   required: true
                },
                price: {
                    required: true,
                    number: true, // Osigurava da je unos broj
                    min: 0       // Osigurava da je broj veći od 0
                },
                reference:{
                    required: false
                }
            },
            messages:{
                date_start: {
                    required: "Datum je obavezan",
                },
                price: {
                    required: "Iznos je obavezan",
                    number: "Unos mora biti broj",
                    min: "Cena mora biti veća od 0"
                }
            }
        });

        function updateInvoices(id) {
            $.ajax({
                url: "{{ route('get_unpaid_invoices') }}",
                type: "POST",
                data: { id: id }, 
                dataType: "json",
                success: function(response) {
                    var invoices = response.invoices;
                var invoicesDiv = $('#invoices');
                invoicesDiv.empty(); // Očisti trenutni sadržaj

                var totalValue = 0; // Varijabla za ukupnu vrednost

                // Dodaj nove fakture
                invoices.forEach(function(invoice) {
                    var formattedDate = new Date(invoice.created_at).toLocaleDateString('hr-HR', {
                        day: '2-digit',
                        month: '2-digit',
                        year: 'numeric'
                    });

                    var invoiceHtml = `
                        <div class="invoice">
                            <p><strong>ID:</strong> ${invoice.id_invoice}</p>
                            <p><strong>Vrednost:</strong> ${invoice.debt} ${invoice.currency}</p>
                            <p><strong>Datum kreiranja:</strong> ${formattedDate}</p>
                        </div>
                    `;
                    invoicesDiv.append(invoiceHtml);

                    // Saberi vrednost
                    totalValue += parseFloat(invoice.debt); // Pretvaranje u float za sabiranje
                });

                // Prikazi ukupnu vrednost
                var totalHtml = `<div class="total-value button-right"><p><strong>Ukupna vrednost dugovanja:</strong> ${totalValue.toFixed(2)} ${invoices[0]?.currency || 'N/A'}</p></div>`;
                invoicesDiv.append(totalHtml);
                },
                error: function(xhr, status, error) {
                    console.error(error);
                }
            });
        }

        
        $('#companySelect').on('change', function() {
            var selectedOption = $(this).find('option:selected');
            var currency = selectedOption.data('currency');
            var companyId = selectedOption.val();

            // Ažuriramo skriveno polje
            $('#currency').val(currency);

            // Prikažemo dodatne sekcije
            if ($(this).val() !== "0") {
                $('#additional-section').show();
                $('#submit-section').show();

                if (companyId && companyId != 0) {
                    updateInvoices(companyId);
                }
            } else {
                $('#additional-section').hide();
                $('#submit-section').hide();
            }
        });
    });
</script>
@endpush
