@extends('_layout.layout')

@section('head_title', __('Izlana Faktura') . ' - ' . __('Kreiranje Fakture'))

@push('head_links')

@endpush

@section('content')

@include('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Kreiranje izlazne fakture"),
    'breadcrumbs' => [
        route('truck.invoices') => __('Izlazne Fakture')
    ]
])

<style>
    .table th:nth-child(2), .table td:nth-child(2) {
        width: 50%; /* Širina druge kolone */
    }
    .table th:nth-child(3), .table th:nth-child(4), .table th:nth-child(5),
    .table td:nth-child(3), .table td:nth-child(4), .table td:nth-child(5) {
        width: 15%; /* Širina kolona za iznose */
    }
    
    .number-row {
        
    }

    .button-usluge {
        float: right;
        margin: 5px;
    }
</style>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title">@lang('Kreiranje nove izlazne fakture')</h3>
                </div>
                <div class="card-heading-actions">
                    <a href="{{route('truck.invoices')}}" class="btn btn-secondary">
                        <i class="fa fa-arrow-left"></i>
                        @lang('Nazad')
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <form id="wizard-validation-form" action="#">
                                    <div>
                                        {{-- <h3>Osnovni podaci</h3>
                                        <section>
                                            <div class="row">
                                                <div class="col-lg-4">
                                                    <div class="form-group">
                                                        <label class="control-label">@lang('Broj fakture')</label>
                                                        <input 
                                                            type="text" 
                                                            class="form-control @errorClass('id_invoice', 'is-invalid') enterable" 
                                                            name="id_invoice" 
                                                            placeholder="@lang('Broj Fakture')" 
                                                            value="{{old('id_invoice', $entity->id_invoice)}}"
                                                        >
                                                        @formError(['field' => 'id_invoice'])
                                                    </div>
                                                </div>
                                                <div class="col-lg-2">
                                                    <div class="form-group">
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="form-group">
                                                        <label class="control-label">@lang('Firma')</label>
                                                        <select id="companySelect" name="company" class="form-control @errorClass('company', 'is-invalid') enterable">
                                                            <option value="0" disabled selected>@lang('Izaberi')</option>
                                                            @foreach($companies as $company)
                                                            <option value="{{$company->id}}" data-currency="{{$company->currency}}" @if(old('company', $entity->company) == $company->id) selected @endif>{{$company->name}}</option>
                                                            @endforeach
                                                        </select>
                                                        @formError(['field' => 'company'])
                                                    </div>
                                                </div>
                                            </div>
                                            <hr>
                                            @php
                                                if($entity->date_start){
                                                    $dateStart = date('d-m-Y', strtotime($entity->date_start));
                                                    $dateEnd = date('d-m-Y', strtotime($entity->date_end));
                                                }else{
                                                    $dateStart = '';
                                                    $dateEnd = '';
                                                }
                                            @endphp
                                            <div class="row">
                                                @if(old('date_start', $dateStart))
                                                <div class="col-lg-6">
                                                    <div class="form-group row">
                                                        <label class="col-sm-3 control-label">@lang('Datum početka')</label>
                                                        <div class="col-sm-5">
                                                            <input
                                                                type="text"
                                                                class="form-control @errorClass('date_start', 'is-invalid') enterable"
                                                                placeholder="@lang('Datum')"
                                                                value="{{old('date_start', $dateStart)}}"
                                                                readonly
                                                            >
                                                            @formError(['field' => 'date_start'])
                                                        </div>
                                                        <input type="hidden" name="date_start" value="{{old('date_start', $dateStart)}}">
                                                    </div>
                                                </div>
                                                @else
                                                <div class="col-lg-6">
                                                    <div class="form-group row">
                                                        <label class="col-sm-3 control-label">@lang('Datum početka')</label>
                                                        <div class="col-sm-5">
                                                            <input
                                                                type="text"
                                                                class="form-control @errorClass('date_start', 'is-invalid') enterable"
                                                                name="date_start"
                                                                id="date_start"
                                                                placeholder="@lang('Datum')"
                                                                value="{{old('date_start', $dateStart)}}"
                                                            >
                                                            @formError(['field' => 'date_start'])
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif
                                                <div class="col-lg-6">
                                                    <div class="form-group row">
                                                        <label class="col-sm-3 control-label">@lang('Rok placanja')</label>
                                                        <div class="col-sm-5">
                                                            <input
                                                                type="text"
                                                                class="form-control @errorClass('date_end', 'is-invalid') enterable"
                                                                name="date_end"
                                                                id="date_end"
                                                                placeholder="@lang('Datum')"
                                                                value="{{old('date_end', $dateEnd)}}"
                                                            >
                                                            @formError(['field' => 'date_end'])
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col-lg-5">
                                                    <div class="form-group">
                                                        <label class="col-sm-3 control-label">@lang('Vozac')</label>
                                                        <select name="drivers[]" class="form-control @errorClass('drivers', 'is-invalid') enterable" multiple>
                                                            <option value="" disabled>@lang('Izaberi')</option>
                                                            @foreach($drivers as $driver)
                                                                <option value="{{$driver->id}}" @if(in_array($driver->id, old('drivers', $entity->drivers->pluck('id')->toArray()))) selected @endif>
                                                                    {{$driver->first_name}} {{$driver->last_name}}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        @formError(['field' => 'drivers'])
                                                    </div>
                                                </div>
                                                <div class="col-lg-1">
                                                    <div class="form-group">
                                                    </div>
                                                </div>
                                                <div class="col-lg-5">
                                                    <div class="form-group">
                                                        <label class="col-sm-3 control-label">@lang('Vozilo')</label>
                                                        <select name="trucks[]" class="form-control select2 @errorClass('trucks', 'is-invalid') enterable" multiple>
                                                            <option value="" disabled>@lang('Izaberi')</option>
                                                            @foreach($trucks as $truck)
                                                                <option value="{{$truck->id}}" @if(in_array($truck->id, old('trucks', $entity->trucks->pluck('id')->toArray()))) selected @endif>
                                                                    {{$truck->producer}} | {{$truck->number_of_plates}}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        @formError(['field' => 'trucks'])
                                                    </div>
                                                </div>
                                            </div>
                                        </section> --}}
                                        <h3>Usluge</h3>
                                        <section>
                                            <table class="table" id="invoiceTable">
                                                <thead>
                                                    <tr>
                                                        <th></th>
                                                        <th>Naziv usluge</th>
                                                        <th>Iznos bez PDV-a</th>
                                                        <th>PDV %</th>
                                                        <th>Iznos ukupno</th>
                                                        <th class="no-print">Akcija</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            <div class="form-group number-row">
                                                                1
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="form-group">
                                                                <input 
                                                                    type="text" 
                                                                    class="form-control @errorClass('id_invoice', 'is-invalid') enterable" 
                                                                    name="id_invoice" 
                                                                    placeholder="@lang('Naziv Usluge')" 
                                                                    value="{{old('id_invoice', $entity->id_invoice)}}"
                                                                >
                                                                @formError(['field' => 'id_invoice'])
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="form-group">
                                                                <input 
                                                                    type="text" 
                                                                    class="form-control @errorClass('id_invoice', 'is-invalid') enterable" 
                                                                    name="id_invoice" 
                                                                    placeholder="@lang('100.00')" 
                                                                    value="{{old('id_invoice', $entity->id_invoice)}}"
                                                                >
                                                                @formError(['field' => 'id_invoice'])
                                                            </div>    
                                                        </td>
                                                        <td>
                                                            <div class="form-group">
                                                                <input 
                                                                    type="text" 
                                                                    class="form-control @errorClass('id_invoice', 'is-invalid') enterable" 
                                                                    name="id_invoice" 
                                                                    placeholder="@lang('0.00')" 
                                                                    value="{{old('id_invoice', $entity->id_invoice)}}"
                                                                >
                                                                @formError(['field' => 'id_invoice'])
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="form-group">
                                                                <input 
                                                                    type="text" 
                                                                    class="form-control @errorClass('id_invoice', 'is-invalid') enterable" 
                                                                    name="id_invoice" 
                                                                    placeholder="@lang('100.00')" 
                                                                    value="{{old('id_invoice', $entity->id_invoice)}}"
                                                                >
                                                                @formError(['field' => 'id_invoice'])
                                                            </div>
                                                        </td>
                                                        <td class="no-print">
                                                            <div class="form-group">
                                                                <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">X</button>
                                                            </div>
                                                        </td> <!-- Dugme za uklanjanje reda -->
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </section>
                                        <h3>Step 3</h3>
                                        <section>
                                            <div class="form-group row">
                                                <div class="col-lg-12">
                                                    <ul class="list-unstyled w-list">
                                                        <li><b>First Name :</b> Jonathan </li>
                                                        <li><b>Last Name :</b> Smith </li>
                                                        <li><b>Emial:</b> jonathan@smith.com</li>
                                                        <li><b>Address:</b> 123 Your City, Cityname. </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </section>
                                        <h3>Step Final</h3>
                                        <section>
                                            <div class="form-group row">
                                                <div class="col-lg-12">
                                                    <input id="acceptTerms-2" name="acceptTerms2" type="checkbox" class="required">
                                                    <label for="acceptTerms-2">I agree with the Terms and Conditions.</label>
                                                </div>
                                            </div>

                                        </section>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@push('footer_scripts')
<script src="{{asset('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')}}"></script>
<script src="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.js')}}"></script>

<script>
    // Funkcija koja se poziva kada se izabere nova opcija
   
</script>

<script>
$(function() {
    
    $(document).ready(function() {

    $('#companySelect').on('change', function() {
        var selectedOption = $(this).find('option:selected');
        var currency = selectedOption.data('currency');

        // Ažuriramo data-currency atribut
        $('#currencyDisplay .input-group-text').text(currency);

        // Ažuriramo skriveno polje
        $('#currency').val(currency);
    });

    $.validator.addMethod("validDate", function(value, element) {
        return moment(value,"DD-MM-YYYY", true).isValid();
    }, "{{ __('Unesite validan format DD-MM-GGGG.') }}");
    $.validator.addMethod("greaterStart", function (value, element, params) {
        //Konvertujemo datume i vracamo error alp je dateStart manji od dateEnd
        var dateStart= $('#entity-form [name="date_start"]').val().split("-")
        dateStart = new Date(dateStart[2], dateStart[1] - 1, dateStart[0]);
        var dateEnd= $('#entity-form [name="date_end"]').val().split("-")
        dateEnd = new Date(dateEnd[2], dateEnd[1] - 1, dateEnd[0]);
        return this.optional(element) || dateStart <= dateEnd;
    },"{{ __('Mora biti veće od datuma početka.') }}");

    $('#entity-form').validate({
        rules: {
            id_invoice: {
                required: true
            },
            company: {
                required: true,
                date: true
            },
            date_start: {
                required: true,
                validDate: true
            },
            date_end: {
                required: true,
                validDate: true,
                greaterStart: '[name="date_start"]'
            },
            driver: {
                required: true,
            },
            truck: {
                required: true,
            },
            price:{
                required: true
            },
        },
        messages: {
            
        }
    });

    $('select').select2({
        minimumResultsForSearch: -1
    });

    $('#date_start').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true
        });

    $('#date_end').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true
        });

    // $('#entity-form [name="date_start"]').on('change', function(e){
    //     e.preventDefault();
    //     let start = $('#entity-form [name="date_start"]').val();
    //     let split = start.split('-');
    //     let end10 = parseInt(split[2]) + 10;

    //     $('#entity-form [name="date_end"]').val(split[0] + '-' + split[1] + '-' + end10);

    // });
    
});

});
</script>
@endpush