@extends('_layout.layout')

@section('head_title', __('Vozila') . ' - ' . __('Vozila'))

@push('head_links')

@endpush

@section('content')

@include('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Vozila"),
    'breadcrumbs' => [
        route('truck.trucks') => __('Vozila')
    ]
])

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title">@lang('Lista Vozila')</h3>
                </div>
                <div class="card-heading-actions">
                    <a href="{{route('truck.trucks_create')}}" class="btn btn-primary">
                        <i class="fa fa-plus"></i>
                        @lang('Dodaj')
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped" id="entity-list-table">
                        <thead>
                            <tr>
                                <th class="">@lang('')</th>
                                <th class="">@lang('Proizvodjač')</th>
                                <th class="">@lang('Naziv Vozila')</th>
                                <th class="">@lang('Broj saobraćajne')</th>
                                <th class="">@lang('Tablice')</th>
                                <th class="disabled-sorting text-right">@lang('Opcije')</th>
                            </tr>
                        </thead>
                        <tbody>
    
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('footer_scripts')
<script>
$(function() {
    
    var blade = {
        datatablesAjaxUrl:"@route('truck.trucks_datatable')"
    };
    
    // DATATABLES
    $('#entity-list-table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            url: blade.datatablesAjaxUrl,
            type: "post",
        },
        "columns": [
            {"data": "image", orderable: false, searchable: false, "className": ""},
            {"data": "producer", "className": ""},
            {"data": "name", "className": ""},
            {"data": "traffic_number", "className": ""},
            {"data": "number_of_plates", "className": ""},
            {"data": "actions", orderable: false, searchable: false, "className": "text-right"}
        ],
        "order": [[0, "asc"]]
    });
    
    
    // DELETE MODAL
    let options = {
        "title": "Obriši",
        "liveSelector": '[data-action="delete"]'
    };
    
    $('#entity-list-table').questionPop(options).on('success.qp', function() {
        $('#entity-list-table').DataTable().draw('page');
    });

});
</script>
@endpush