<?php

Route::get('/', 'AdminBaseController@index')->name('index');

// WEBSITES
// =================
Route::middleware('can:admin:websites')->name('websites.')->prefix('/websites')->group(function() {  

    Route::get('/', 'WebsitesController@index')->name('index');
    Route::post('/datatable', 'WebsitesController@datatable')->name('datatable');
    Route::get('/create', 'WebsitesController@create')->name('create');
    Route::post('/create', 'WebsitesController@store');
    Route::get('/{entity}/edit', 'WebsitesController@edit')->name('edit');
    Route::post('/{entity}/edit', 'WebsitesController@update');
    Route::post('{entity}/activate-deactivate', 'WebsitesController@changeActive')->name('change_active');
    Route::post('/{entity}/delete', 'WebsitesController@delete')->name('delete');
    Route::post('/{entity}/delete-image', 'WebsitesController@deleteImage')->name('delete_image');
});

// PODESAVANJA
// ===============
Route::middleware('can:admin:settings')->name('settings.')->prefix('/settings')->group(function() {
    
    Route::get('/', 'SettingsController@index')->name('index');
    Route::post('/', 'SettingsController@update')->name('edit');
    Route::post('/{entity}/delete-image', 'SettingsController@deleteImage')->name('delete_image');
});