<?php if(!empty($priorityArticle)): ?>
<div class="single-priority-article card" data-article-id="<?php echo e($priorityArticle->id); ?>" style="margin-bottom: 10px;">
    <div class="card-header d-flex justify-content-between align-items-center" style="padding: .4rem 10px;">
        <div class="list-article-handle">
            <span class="btn btn-sm btn-secondary single-priority-handle">
                <div>
                    <i class="fa fa-caret-right"></i>
                    <i class="fa fa-bars ml-1"></i>
                </div>
            </span>
        </div>
        <div class="list-item-priority-buttons">
            <div class="btn-group">
                <a class="btn btn-primary waves-effect" 
                    href="<?php echo e(route('articles.edit', ['entity' => $priorityArticle->id])); ?>"
                >
                    <i class="fa fa-edit"></i>      
                </a>
                <button 
                    class="btn btn-warning waves-effect article-priority-remove"
                    type="button"
                    data-title="<?php echo app('translator')->get('Ukloni vest iz svih prioriteta'); ?>"
                    title="<?php echo app('translator')->get('Ukloni vest iz svih prioriteta'); ?>"
                    data-text="<?php echo app('translator')->get('Da li ste sigurni da želite da obrišete vest iz svih prioriteta'); ?> <?php echo e($priorityArticle->heading); ?>?"
                    data-label="<?php echo e($priorityArticle->heading); ?>"
                    data-ajax-url="<?php echo e(route('priorities.remove_article_from_all_priorities')); ?>"
                    data-action="remove"
                    data-id="<?php echo e($priorityArticle->id); ?>"
                    data-ajax-params='{"article_id": "<?php echo e($priorityArticle->id); ?>"}'
                    data-no-text="<?php echo app('translator')->get('Ne'); ?>"
                    data-yes-text="<?php echo app('translator')->get('Da'); ?>"
                >
                <i class="fa fa-times-circle"></i>
                </button>
                <button 
                    class="btn btn-danger waves-effect delete"
                    data-title="<?php echo app('translator')->get('Obriši'); ?>"
                    title="<?php echo app('translator')->get('Obriši'); ?>"
                    data-action="delete"
                    data-id="<?php echo e($priorityArticle->id); ?>"
                >
                    <i class="fa fa-trash"></i>
                </button>
            </div>
        </div>
    </div>
    <div class="card-body" style="padding: .3rem 10px;">
        <div class="row" style="margin:0 -10px;">
            <div class="col-sm-4 col-lg-3 mb-2 mb-sm-0" style="padding: 0 5px 0 10px;">
                <img src="<?php echo e($priorityArticle->image_t); ?>" alt="<?php echo e(\Str::words($priorityArticle->heading, 4)); ?>" class="w-100">
            </div>
            <div class="col-sm-8 col-lg-9" style="padding: 0 10px 0 5px;">
                <p class="list-article-title mb-1"><?php echo e($priorityArticle->heading); ?></p>
                <div class="d-flex flex-wrap align-items-center">
                    <p class="mr-2 mb-0">
                        <span class="mr-2"><strong><ins><?php echo app('translator')->get('Id'); ?></ins>:</strong> <?php echo e($priorityArticle->id); ?></span>
                        <span class="badge badge-warning"><?php echo e(optional($priorityArticle->category)->name); ?>/<?php echo e(optional($priorityArticle->subCategory)->name); ?></span>
                    </p>
                    <p class="mb-0">
                        <strong><?php echo app('translator')->get('Objavljeno'); ?>:</strong>
                        <?php echo e($priorityArticle->publish_at); ?>

                    </p>
                    <?php if($priorityArticle->category_id == config('website.ninova_nagrada_category_id')): ?>
                    <p class="mb-0">
                        <strong>&nbsp;<?php echo app('translator')->get('Preheading'); ?>:</strong>
                        <?php echo e($priorityArticle->preheading); ?>

                    </p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?><?php /**PATH /opt/cms/resources/views/priorities/partials/list_priority/list_priority_item.blade.php ENDPATH**/ ?>