<?php if($entity->status == 0): ?>
<div class="btn-group">
    <button 
        id="openModalBtn" 
        type="button"
        class="btn btn-success"
        data-id="<?php echo e($entity->id); ?>"
        data-id-invoice="<?php echo e($entity->id_invoice); ?>"
        data-price="<?php echo e($entity->price); ?>"
        data-debt="<?php echo e($entity->debt); ?>"
        data-price-part="<?php echo e($entity->price_part); ?>"
        data-currency="<?php echo e($entity->currency); ?>"
        > 
        Potvrdi placanje
    </button>
</div>
<?php else: ?>
    <?php if($entity->date_done): ?>
    <div class="btn-group">
        <button 
                type="button"
                class="btn btn-light"
                disabled
            >
            Placeno: <?php echo e(\Carbon\Carbon::parse($entity->date_done)->format('d-m-Y')); ?>

            </button>
    </div>
    <?php endif; ?>
<?php endif; ?>

<script>
    function showInvoice(invoiceId) {
        console.log('invoiceID', invoiceId);
        // Generišemo URL koristeći imenovanu rutu
        var invoiceUrl = "<?php echo e(route('truck.invoices.A4View', ['id' => 'INVOICE_ID_PLACEHOLDER'])); ?>".replace('INVOICE_ID_PLACEHOLDER', invoiceId);
        document.getElementById('invoiceFrame').src = invoiceUrl;
        $('#invoiceModal').modal('show');
    }
</script>
<?php /**PATH /opt/cms/resources/views/truck/invoices/partials/table/paid_actions.blade.php ENDPATH**/ ?>