<?php $__env->startPush('head_links'); ?>
<link href="<?php echo e(asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopPush(); ?>

<form id="entity-form" class="form-horizontal" method="post" action="" 
      enctype="multipart/form-data" autocomplete="off">
    <div class="row">
        <div class="col-lg-7 align-self-center">
            <?php echo csrf_field(); ?>
            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('Ime'); ?><sup>*</sup></label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("first_name") ? 'is-invalid' : ""; ?>" 
                        name="first_name" 
                        placeholder="<?php echo app('translator')->get('Ime'); ?>" 
                        value="<?php echo e(old('first_name', $entity->first_name)); ?>"
                    >
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'first_name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('Prezime'); ?><sup>*</sup></label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("last_name") ? 'is-invalid' : ""; ?>" 
                        name="last_name" 
                        placeholder="<?php echo app('translator')->get('Prezime'); ?>" 
                        value="<?php echo e(old('last_name', $entity->last_name)); ?>"
                    >
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'last_name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>
            
            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('Email'); ?><sup>*</sup></label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("email") ? 'is-invalid' : ""; ?>" 
                        name="email" 
                        placeholder="<?php echo app('translator')->get('Email'); ?>" 
                        value="<?php echo e(old('email', $entity->email)); ?>"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-at"></i>
                        </span>
                    </span>
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'email'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>
            
            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('Telefon'); ?></label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("phone") ? 'is-invalid' : ""; ?>" 
                        name="phone" 
                        placeholder="<?php echo app('translator')->get('Telefon'); ?>" 
                        value="<?php echo e(old('phone', $entity->phone)); ?>"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-phone"></i>
                        </span>
                    </span>
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'phone'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('JMBG'); ?></label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("jmbg") ? 'is-invalid' : ""; ?>" 
                        name="jmbg" 
                        placeholder="<?php echo app('translator')->get('JMBG'); ?>" 
                        value="<?php echo e(old('jmbg', $entity->jmbg)); ?>"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-id-card-o"></i>
                        </span>
                    </span>
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'jmbg'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>
            
        </div>
        <div class="col-4 offset-1">
            
        </div>
    </div>
    <hr>
    <div class="form-group row">
        <div class="col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light">
                <i class="fa fa-save"></i>
                <?php echo app('translator')->get('Sačuvaj'); ?>
            </button>
        </div>
    </div>
</form>

<?php $__env->startPush('footer_scripts'); ?>
<script src="<?php echo e(asset('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')); ?>"></script>
<script src="<?php echo e(asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.js')); ?>"></script>
<script>
$(function() {
    
    $(document).ready(function() {
    $('#entity-form').validate({
        rules: {
            first_name: {
                required: true
            },
            last_name: {
                required: true
            },
            phone: {
                required: true,
                maxlength: 15
            },
            email: {
                required: true,
                email: true
            },
            jmbg: {
                required: true,
                maxlength: 13
            }
        },
        messages: {
            jmbg: {
                digits: "JMBG može sadržavati samo brojeve.",
                maxlength: "JMBG može sadržavati najviše 13 cifara."
            },
            phone: {
                digits: "Telefon može sadržavati samo brojeve.",
                maxlength: "Telefon može sadržavati najviše 15 cifara."
            }
        },
    });
});

});
</script>
<?php $__env->stopPush(); ?><?php /**PATH /home/drventar/vd-trans.com/fakture/resources/views/truck/drivers/partials/form.blade.php ENDPATH**/ ?>