<?php $__env->startPush('head_links'); ?>
<link href="<?php echo e(asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopPush(); ?>

<form id="entity-form" class="form-horizontal" method="post" action="" 
      enctype="multipart/form-data" autocomplete="off">
    <div class="row">
        <div class="col-lg-7 align-self-center">
            <?php echo csrf_field(); ?>
            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('Proizvodjač'); ?><sup>*</sup></label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("producer") ? 'is-invalid' : ""; ?>" 
                        name="producer" 
                        placeholder="<?php echo app('translator')->get('Proizvodjač'); ?>" 
                        value="<?php echo e(old('producer', $entity->producer)); ?>"
                    >
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'producer'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('Naziv kamiona'); ?><sup>*</sup></label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("name") ? 'is-invalid' : ""; ?>" 
                        name="name" 
                        placeholder="<?php echo app('translator')->get('Naziv kamiona'); ?>" 
                        value="<?php echo e(old('name', $entity->name)); ?>"
                    >
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>
            
            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('Broj saobraćajne'); ?></label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("phone") ? 'is-invalid' : ""; ?>" 
                        name="traffic_number" 
                        placeholder="<?php echo app('translator')->get('Broj saobraćajne'); ?>" 
                        value="<?php echo e(old('traffic_number', $entity->traffic_number)); ?>"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-credit-card"></i>
                        </span>
                    </span>
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'traffic_number'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('Tablice'); ?></label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("number_of_plates") ? 'is-invalid' : ""; ?>" 
                        name="number_of_plates" 
                        placeholder="<?php echo app('translator')->get('Tablice'); ?>" 
                        value="<?php echo e(old('number_of_plates', $entity->number_of_plates)); ?>"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-solid fa-truck"></i>
                        </span>
                    </span>
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'number_of_plates'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>
            
        </div>
        <div class="col-4 offset-1">
            
        </div>
    </div>
    <hr>
    <div class="form-group row">
        <div class="col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light">
                <i class="fa fa-save"></i>
                <?php echo app('translator')->get('Sačuvaj'); ?>
            </button>
        </div>
    </div>
</form>

<?php $__env->startPush('footer_scripts'); ?>
<script src="<?php echo e(asset('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')); ?>"></script>
<script src="<?php echo e(asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.js')); ?>"></script>
<script>
$(function() {
    
    $(document).ready(function() {
    $('#entity-form').validate({
        rules: {
            producer: {
                required: true
            },
            name: {
                required: true
            },
            traffic_number: {
                required: true,
                maxlength: 20
            },
            number_of_plates: {
                required: true,
                maxlength: 10
            }
        },
        messages: {
            
        },
    });
});

});
</script>
<?php $__env->stopPush(); ?><?php /**PATH /opt/cms/resources/views/truck/trucks/partials/form.blade.php ENDPATH**/ ?>